//OHSAT GAMES TUTORIAL: MEGALAGA 1
//MEGATEAMWORK Makes the MEGADREAM Work 

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>

// Declarations
int offset = 0;

int main()
{
    SYS_disableInts();
    VDP_loadTileSet(background.tileset, 1, DMA);  // Load tile set at index 1
    PAL_setPalette(PAL1, background.palette->data, DMA);  // Set palette
    VDP_setScrollingMode(HSCROLL_PLANE, VSCROLL_PLANE);
    SYS_enableInts();

    int i = 0;
    int thex = 0;
    int they = 0;
    int val = 1;

    // Fill the background with random tiles
    for (int i = 0; i < 1280; i++)  // 40x32 = full screen + buffer
    {
        int thex = i % 40;
        int they = i / 40;

        // Randomly choose between blank (0), star1 (1), or star2 (2)
        int val = (random() % (10 - 1 + 1)) + 1;  // 0, 1, or 2
        if(val > 3) val = 1;
        VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, 0, 0, val), thex, they);
    }

    while (1)
    {
        // Scroll the background vertically
        VDP_setVerticalScroll(BG_B, offset -= 2);
        if (offset <= -256) offset = 0;

        SYS_doVBlankProcess();
    }

    return 0;
}

////////////////////NOTES////////////////////

/*

*/

/////////EXPERIMENTATION IDEAS///////////////

/*
Using my current code (see below) the number of stars drawn in the sky is a bit of overkill, IMO. 
Let's see if we can change the formula to something that looks a bit more empty. 

Current code: 

#include <genesis.h>
#include <resources.h>

// Declarations
int offset = 0;

int main()
{
    SYS_disableInts();
    VDP_loadTileSet(background.tileset, 1, DMA);  // Load tile set at index 1
    PAL_setPalette(PAL1, background.palette->data, DMA);  // Set palette
    VDP_setScrollingMode(HSCROLL_PLANE, VSCROLL_PLANE);
    SYS_enableInts();

    // Fill the background with random tiles
    for (int i = 0; i < 40 * 32; i++)  // 40x32 = full screen + buffer
    {
        int x = i % 40;
        int y = i / 40;

        // Randomly choose between blank (0), star1 (1), or star2 (2)
        int tileIndex = (random() % 3);  // 0, 1, or 2
        VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, 0, 0, tileIndex + 1), x, y);
    }

    while (1)
    {
        // Scroll the background vertically
        VDP_setVerticalScroll(BG_B, offset -= 1);
        if (offset <= -256) offset = 0;

        SYS_doVBlankProcess();
    }

    return 0;
}

Attempt 1: Using declarations to make the stars spare and ensure infinite scroll effect

Codebase: 

#include <genesis.h>
#include <resources.h>

#define SCREEN_WIDTH  40
#define SCREEN_HEIGHT 28  // 28 visible rows, rest is buffer
#define TILE_BLANK    1   // index in VRAM
#define TILE_STAR1    2
#define TILE_STAR2    3

int offset = 0;
int scroll_row = 31;  // Start from bottom row for wrapping

void draw_row(int row) {
    for (int x = 0; x < SCREEN_WIDTH; x++) {
        int r = random() % 100;

        int tile = TILE_BLANK;
        if (r < 10) tile = TILE_STAR1;   // 10% chance
        else if (r < 15) tile = TILE_STAR2;  // 5% chance
        // else stays blank (85%)

        VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile), x, row);
    }
}

int main() {
    SYS_disableInts();
    VDP_loadTileSet(background.tileset, 1, DMA);  // Load tiles starting at index 1
    PAL_setPalette(PAL1, background.palette->data, DMA);
    VDP_setScrollingMode(HSCROLL_PLANE, VSCROLL_PLANE);
    SYS_enableInts();

    // Fill the entire background initially
    for (int y = 0; y < 32; y++) {
        draw_row(y);
    }

    while (1) {
        offset -= 1;
        if (offset <= -8) {
            offset = 0;
            scroll_row--;

            if (scroll_row < 0) scroll_row = 31;
            draw_row(scroll_row);
        }

        VDP_setVerticalScroll(BG_B, offset);
        SYS_doVBlankProcess();
    }

    return 0;
}

Results: The number of stars generated looks much better but the scrolling here is done tile-by-tile. This
is fine for a Tetris-like game but the original code of VDP_setVerticalScroll(BG_B, offset -= 2); 
looked much smoother. 

Attempt 2: 

Codebase: 

#include <genesis.h>
#include <resources.h>

#define SCREEN_WIDTH  40
#define TILE_BLANK    1
#define TILE_STAR1    2
#define TILE_STAR2    3

int pixel_offset = 0;     // Fine scroll value (per pixel)
int logical_row = 31;     // Which tile row to replace
int pixel_counter = 0;    // How many pixels have scrolled total

void draw_row(int row) {
    for (int x = 0; x < SCREEN_WIDTH; x++) {
        int r = random() % 1000;

        int tile = TILE_BLANK;
        if (r < 10) tile = TILE_STAR1;      // 1% chance
        else if (r < 15) tile = TILE_STAR2; // 0.5% chance

        VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile), x, row);
    }
}

int main() {
    SYS_disableInts();
    VDP_loadTileSet(background.tileset, 1, DMA);
    PAL_setPalette(PAL1, background.palette->data, DMA);
    VDP_setScrollingMode(HSCROLL_PLANE, VSCROLL_PLANE);
    SYS_enableInts();

    // Fill full background initially
    for (int y = 0; y < 32; y++) {
        draw_row(y);
    }

    while (1) {
        pixel_offset -= 2;
        pixel_counter += 2;

        if (pixel_offset <= -256) pixel_offset = 0;

        // Every 8 pixels, we need to draw a new row at the top
        if (pixel_counter >= 8) {
            pixel_counter = 0;
            logical_row--;
            if (logical_row < 0) logical_row = 31;
            draw_row(logical_row);
        }

        VDP_setVerticalScroll(BG_B, pixel_offset);
        SYS_doVBlankProcess();
    }

    return 0;
}

Results: The scrolling is significantly smoother and the star field (I put a space so don't sue me) is 
still sparsely populated. I like these results. Were I to move forward with my own space shooter I would
use this code. 

I think I will make a third attempt trying to keep the code more true to what is outlined in the OHSAT tutorial. 

Attempt 3: 

Codebase: 

#include <genesis.h>
#include <resources.h>

// Declarations
int offset = 0;

int main()
{
    SYS_disableInts();
    VDP_loadTileSet(background.tileset, 1, DMA);  // Load tile set at index 1
    PAL_setPalette(PAL1, background.palette->data, DMA);  // Set palette
    VDP_setScrollingMode(HSCROLL_PLANE, VSCROLL_PLANE);
    SYS_enableInts();

    int i = 0;
    int thex = 0;
    int they = 0;
    int val = 1;

    // Fill the background with random tiles
    for (int i = 0; i < 1280; i++)  // 40x32 = full screen + buffer
    {
        int thex = i % 40;
        int they = i / 40;

        // Randomly choose between blank (0), star1 (1), or star2 (2)
        int val = (random() % (10 - 1 + 1)) + 1;  // 0, 1, or 2
        if(val > 3) val = 1;
        VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, 0, 0, val), thex, they);
    }

    while (1)
    {
        // Scroll the background vertically
        VDP_setVerticalScroll(BG_B, offset -= 2);
        if (offset <= -256) offset = 0;

        SYS_doVBlankProcess();
    }

    return 0;
}

Results: There were some issues in the error handling that I may address but it compiles fine and looks good. Also, the 
code is significantly smaller. I think I'll keep this for now and use it moving foward with the tutorial. 

*/

///////////ERROR HANDLING////////////////////
/*
src/main.c: In function 'main':
src/main.c:23:9: warning: unused variable 'val' [-Wunused-variable]
     int val = 1;
         ^~~
src/main.c:22:9: warning: unused variable 'they' [-Wunused-variable]
     int they = 0;
         ^~~~
src/main.c:21:9: warning: unused variable 'thex' [-Wunused-variable]
     int thex = 0;
         ^~~~
src/main.c:20:9: warning: unused variable 'i' [-Wunused-variable]
     int i = 0;
         ^
echo "out/res/resources.o out/src/main.o" > out/cmd_
C:/SGDK/bin/gcc.exe -m68000 -BC:/SGDK/bin -n -T C:/SGDK/md.ld -nostdlib out/sega.o @out/cmd_ C:/SGDK/lib/libmd.a C:/SGDK/lib/libgcc.a -o out/rom.out -Wl,--gc-sections -flto
C:/SGDK/bin/rm.exe out/cmd_
C:/SGDK/bin/objcopy.exe -O binary out/rom.out out/rom.bin
java -jar C:/SGDK/bin/sizebnd.jar out/rom.bin -sizealign 131072 -checksum
C:/SGDK/bin/nm.exe --plugin=liblto_plugin-0.dll -n out/rom.out > out/symbol.txt
rm res/resources.rs

*/